/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.compat.computercraft;

import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorTileEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ElectricMotorPeripheral
implements IPeripheral {
    protected final List<IComputerAccess> connected = new ArrayList<IComputerAccess>();
    protected String type;
    protected ElectricMotorTileEntity tileEntity;

    public ElectricMotorPeripheral(String type, ElectricMotorTileEntity tileEntity) {
        this.type = type;
        this.tileEntity = tileEntity;
    }

    public List<IComputerAccess> getConnectedComputers() {
        return this.connected;
    }

    public Object getTarget() {
        return this.tileEntity;
    }

    public void attach(IComputerAccess computer) {
        this.connected.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.connected.remove(computer);
    }

    public boolean equals(IPeripheral iPeripheral) {
        return iPeripheral == this;
    }

    @LuaFunction
    public final String getType() {
        return this.type;
    }

    @LuaFunction(mainThread=true)
    public final void setSpeed(int rpm) throws LuaException {
        if (rpm == this.getSpeed()) {
            return;
        }
        if (this.tileEntity != null && !this.tileEntity.setRPM(rpm)) {
            throw new LuaException("Speed is set too many times per second (Anti Spam).");
        }
    }

    @LuaFunction(mainThread=true)
    public final void stop() throws LuaException {
        this.setSpeed(0);
    }

    @LuaFunction(mainThread=true)
    public final int getSpeed() throws LuaException {
        if (this.tileEntity != null) {
            return this.tileEntity.getRPM();
        }
        return 0;
    }

    @LuaFunction(mainThread=true)
    public final int getStressCapacity() throws LuaException {
        if (this.tileEntity != null) {
            return this.tileEntity.getGeneratedStress();
        }
        return 0;
    }

    @LuaFunction(mainThread=true)
    public final int getEnergyConsumption() throws LuaException {
        if (this.tileEntity != null) {
            return this.tileEntity.getEnergyConsumption();
        }
        return 0;
    }

    @LuaFunction(mainThread=true)
    public final float rotate(int deg, Optional<Integer> rpm) throws LuaException {
        if (this.tileEntity != null) {
            int _rpm = rpm.orElse(this.getSpeed());
            if (rpm.isPresent()) {
                this.setSpeed(deg < 0 ? -_rpm : _rpm);
            }
            return (float)ElectricMotorTileEntity.getDurationAngle(deg, 0.0f, _rpm) / 20.0f;
        }
        return 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final float translate(int blocks, Optional<Integer> rpm) throws LuaException {
        if (this.tileEntity != null) {
            int _rpm = rpm.orElse(this.getSpeed());
            if (rpm.isPresent()) {
                this.setSpeed(blocks < 0 ? -_rpm : _rpm);
            }
            return (float)ElectricMotorTileEntity.getDurationDistance(blocks, 0.0f, _rpm) / 20.0f;
        }
        return 0.0f;
    }

    @LuaFunction(mainThread=true)
    public int getMaxInsert() {
        return ElectricMotorTileEntity.MAX_IN;
    }

    @LuaFunction(mainThread=true)
    public int getMaxExtract() {
        return ElectricMotorTileEntity.MAX_OUT;
    }
}

